//------------------------------------------------------------------------------------------------------------------------------------------------
// PA2 Extras - Extra Recipes
//------------------------------------------------------------------------------------------------------------------------------------------------
// Author: RicTheCoder
// Contributors: ShiftTheDev, ChosenArchitect
//
// A script that adds extra recipes with the ability to turn them on and off, just set the property 'enable' to false and the recipe won't
// be registered.
//
// Recipes have a simplified way of being created, so no need to provide a specific pattern for shaped recipes, it will be assumed.
//
// When using the advance recipes to add custom ones, all required fields need to be provided.
//------------------------------------------------------------------------------------------------------------------------------------------------

// Item Variables
// - These are used to facilitate the input of items
const mekCreativeCube = { type: "forge:partial_nbt", item: "mekanism:creative_energy_cube", nbt: {mekData:{EnergyContainers:[{stored:"18446744073709551615.9999"}]}} }

// Shaped Recipes
// - 'output' is required, the item to output, follows the normal kubejs rules
// - 'inputs' is required, the input items to make the recipe, follows the normal kubejs rules
// - 'enable' is required, if true the recipe will register, if false it will not
// - 'outputs' can replace 'output', takes a list of objects that have the output and overrides for inputs
//   - 'output' is required, the item to output, follows the normal kubejs rules
//   - 'overrides' is used to replace things on the 'inputs', add a '%x' to the overrideable slot, where 'x' is the key for the override
//
// The patterns are assumed from the input items, just set an item to "" to ignore the slot
const shapedRecipes = [
	{
		// Infinity Pipe Upgrade (With all creative things this made sense, and it is not that overpowered due to the way the recipe is)
		// - 4x Final Star Shards
		// - 2x Fading Matter Blocks
		// - 2x Magnum Omega Star
		// - 1x Ultimate Pipe Upgrade
		output: "pipez:infinity_upgrade",
		inputs: [
			"projectexpansion:final_star_shard", "projectexpansion:magnum_star_omega", "projectexpansion:final_star_shard",
			"projectexpansion:fading_matter_block", "pipez:ultimate_upgrade", "projectexpansion:fading_matter_block",
			"projectexpansion:final_star_shard", "projectexpansion:magnum_star_omega", "projectexpansion:final_star_shard"
		],
		enable: true
	},
	{
		// Max Storage Upgrade (With all creative things this also made sense, and it is not that overpowered due to the way the recipe is)
		// - 4x Final Star Shards
		// - 2x Fading Matter Blocks
		// - 2x Magnum Omega Star
		// - 1x Netherite Upgrade
		output: "functionalstorage:max_storage_upgrade",
		inputs: [
			"projectexpansion:final_star_shard", "projectexpansion:magnum_star_omega", "projectexpansion:final_star_shard",
			"projectexpansion:fading_matter_block", "functionalstorage:netherite_upgrade", "projectexpansion:fading_matter_block",
			"projectexpansion:final_star_shard", "projectexpansion:magnum_star_omega", "projectexpansion:final_star_shard"
		],
		enable: true
	},
	{
		// Creative Bin
		// - 4x Final Star
		// - 4x Fading Matter Blocks
		// - 1x Creative Vending Upgrade
		output: "mekanism:creative_bin",
		inputs: [
			"projectexpansion:final_star", "projectexpansion:fading_matter_block", "projectexpansion:final_star",
			"projectexpansion:fading_matter_block", "functionalstorage:creative_vending_upgrade", "projectexpansion:fading_matter_block",
			"projectexpansion:final_star", "projectexpansion:fading_matter_block", "projectexpansion:final_star"
		],
		enable: true
	},
    {
        // Ruby Block
        // - 9x Ruby
        output: "thermal:ruby_block",
        inputs: [
            "thermal:ruby", "thermal:ruby", "thermal:ruby",
            "thermal:ruby", "thermal:ruby", "thermal:ruby",
            "thermal:ruby", "thermal:ruby", "thermal:ruby"
        ],
        enable: true
    },
    {
        // Sapphire Block
        // - 9x Sapphire
        output: "thermal:sapphire_block",
        inputs: [
            "thermal:sapphire", "thermal:sapphire", "thermal:sapphire",
            "thermal:sapphire", "thermal:sapphire", "thermal:sapphire",
            "thermal:sapphire", "thermal:sapphire", "thermal:sapphire"
        ],
        enable: true
    },
    {
        // Creative Battery (Draconic Evolution)
        // - 1x Shattered Singularities
        // - 4x Final Stars
        // - 2x Energy Processors
        // - 1x Creative Energy Cube
        // - 1x Reactor Core
        output: "draconicevolution:creative_op_capacitor",
        inputs: [
            "projectexpansion:final_star", mekCreativeCube, "projectexpansion:final_star",
            "appflux:energy_processor", "advanced_ae:shattered_singularity", "appflux:energy_processor",
            "projectexpansion:final_star", "draconicevolution:reactor_core", "projectexpansion:final_star"
        ],
        enable: true
    },
    {
		// Creative Crate
        // - 1x Shattered Singularities
		// - 3x Radiant Casing
        // - 3x Shadow Casing
        // - 1x Creative Bin
        // - 1x Void Casing
		output: "create:creative_crate",
		inputs: [
			"create:refined_radiance_casing", "functionalstorage:creative_vending_upgrade", "create:shadow_steel_casing",
            "create:refined_radiance_casing", "advanced_ae:shattered_singularity", "create:shadow_steel_casing",
            "create:refined_radiance_casing", "createutilities:void_casing", "create:shadow_steel_casing"
		],
		enable: true
	},
    {
        // Creative Batteries
        // - 1x Shattered Singularities
        // - 6x Energy Processors
        // - 1x Creative Energy Cube
        // - 1x Non Creative Battery (equal to the creative result)
        inputs: [
            "appflux:energy_processor", mekCreativeCube, "appflux:energy_processor",
            "appflux:energy_processor", "advanced_ae:shattered_singularity", "appflux:energy_processor",
            "appflux:energy_processor", "%bat", "appflux:energy_processor"
        ],
        outputs: [
            {
                output: "cyclic:battery_infinite",
                overrides: { "bat": "cyclic:battery" }
            },
            {
                output: "integrateddynamics:energy_battery_creative",
                overrides: { "bat": "integrateddynamics:energy_battery" }
            },
            {
                output: "powah:energy_cell_creative",
                overrides: { "bat": "powah:energy_cell_nitro" }
            },
            {
                output: "rftoolspower:dimensionalcell_creative",
                overrides: { "bat": "rftoolspower:dimensionalcell_advanced" }
            },
            {
                output: "createaddition:creative_energy",
                overrides: { "bat": "createaddition:electric_motor" }
            },
            {
                output: "wormhole:creative_energy_cell",
                overrides: { "bat": "wormhole:advanced_energy_cell" }
            },
            {
                output: "thermal:rf_coil_creative_augment",
                overrides: { "bat": "thermal_extra:abyssal_rf_coil_augment" }
            }
        ],
        enable: true
    },
    {
        // Creative Tanks
        // - 1x Shattered Singularities
        // - 6x Infinite Fluid Storage Part
        // - 1x Creative Fluid Tank
        // - 1x Non Creative Tank (equal to the creative result)
        inputs: [
            "extradisks:infinite_fluid_storage_part", "mekanism:creative_fluid_tank", "extradisks:infinite_fluid_storage_part",
            "extradisks:infinite_fluid_storage_part", "advanced_ae:shattered_singularity", "extradisks:infinite_fluid_storage_part",
            "extradisks:infinite_fluid_storage_part", "%tank", "extradisks:infinite_fluid_storage_part"
        ],
        outputs: [
            {
                output: "create:creative_fluid_tank",
                overrides: { "tank": "create:fluid_tank" }
            },
            {
                output: "create_connected:creative_fluid_vessel",
                overrides: { "tank": "create_connected:fluid_vessel" }
            },
            {
                output: "thermal:fluid_tank_creative_augment",
                overrides: { "tank": "thermal_extra:abyssal_fluid_tank_augment" }
            }
        ],
        enable: true
    },
    {
        // Warden Plushie
        output: "plushies:warden_plushie",
        inputs: [
            'deeperdarker:soul_crystal', 'deeperdarker:soul_dust',  'deeperdarker:sculk_bone', 
            'deeperdarker:soul_dust', 'deeperdarker:heart_of_the_deep', 'deeperdarker:soul_dust', 
            'deeperdarker:sculk_bone', 'deeperdarker:soul_dust', 'deeperdarker:soul_crystal'
        ],
        enable: true
    },
    {
        // Bee Plushie
        output: "plushies:bee_plushie",
        inputs: [
            'the_bumblezone:windy_air', 'the_bumblezone:crystalline_flower',  'the_bumblezone:windy_air', 
            'the_bumblezone:stinger_spear', 'the_bumblezone:royal_jelly_bottle', 'the_bumblezone:crystal_cannon', 
            'the_bumblezone:windy_air', 'allthecompressed:honey_block_3x', 'the_bumblezone:windy_air'
        ],
        enable: true
    },
    {
        // Dragon Plushie
        output: "plushies:dragon_plushie",
        inputs: [
            'apotheosis:infused_breath', 'cyclic:charm_stone',  'apotheosis:infused_breath', 
            'powah:ender_core', 'draconicevolution:awakened_core', 'minecraft:dragon_head', 
            'ends_delight:dragon_leg_with_sauce_block', 'minecraft:dragon_egg', 'reliquary:magicbane'
        ],
        enable: true
    },
    {
        // Wither Plushie
        output: "plushies:wither_plushie",
        inputs: [
            'mob_grinding_utils:tinted_glass', 'ars_nouveau:glyph_wither', 'mob_grinding_utils:tinted_glass', 
            'cyclic:charm_wither', 'sophisticatedbackpacks:everlasting_upgrade', 'reliquary:witherless_rose', 
            'mob_grinding_utils:tinted_glass', 'industrialforegoing:wither_builder', 'mob_grinding_utils:tinted_glass'
        ],
        enable: true
    },
    {
        // Evoker Plushie
        output: "plushies:evoker_plushie",
        inputs: [
            'trials:ominous_bottle', 'cyclic:soulstone', 'trials:ominous_bottle', 
            'trials:trial_key_ominous', 'ars_nouveau:archmage_spell_book', 'trials:trial_key', 
            'trials:ominous_bottle', 'minecraft:bell', 'trials:ominous_bottle'
        ],
        enable: true
    },
    {
        // Pig Plushie
        output: "plushies:pig_plushie",
        inputs: [
            'farmersdelight:skillet', 'quarkdelight:cooked_whole_crab', 'create:chocolate_glazed_berries', 
            'farmersdelight:rice_roll_medley_block', 'nethersdelight:stuffed_hoglin', 'farmersdelight:shepherds_pie_block', 
            'create:sweet_roll', 'farmersdelight:roast_chicken_block', 'farmersdelight:cooking_pot'
        ],
        enable: true
    },
    {
        // Elder Guardian Plushie
        output: "plushies:elder_guardian_plushie",
        inputs: [
            'minecraft:sponge', 'thermal:diving_helmet', 'cyclic:charm_water', 
            'cyclic:antimatter_wand', 'minecraft:conduit', 'cyclic:spell_water', 
            'oceansdelight:elder_guardian_slab', 'reliquary:emperor_chalice', 'oceansdelight:guardian_soup'
        ],
        enable: true
    },
    {
        // Goat Plushie
        output: "plushies:goat_plushie",
        inputs: [
            'rftoolsdim:common_essence', 'ae2:singularity', 'rftoolsdim:common_essence', 
            'reliquary:glacial_staff', 'mekanism:quantum_entangloporter', 'handcrafted:goat_trophy', 
            'rftoolsdim:common_essence', 'powah:charged_snowball', 'rftoolsdim:common_essence'
        ],
        enable: true
    },
    {
        // Axolotl Plushie
        output: "plushies:axolotl_plushie",
        inputs: [
            'allthecompressed:copper_block_3x', 'allthecompressed:amethyst_block_4x', 'allthecompressed:diamond_block_2x', 
            'allthecompressed:cobblestone_5x', 'allthecompressed:clay_4x', 'allthecompressed:cobbled_deepslate_5x', 
            'allthecompressed:iron_block_3x', 'allthecompressed:calcite_4x', 'allthecompressed:gold_block_2x'
        ],
        enable: true
    },
    {
        // Creative Energy Cube (Mekanism) - Empty
        output: "mekanism:creative_energy_cube",
        inputs: [
            'mekanism:ultimate_energy_cube', 'mekanism:ultimate_induction_cell', 'mekanism:ultimate_energy_cube', 
            'mekanism:ultimate_induction_provider', 'mekanism:ultimate_energy_cube', 'mekanism:ultimate_induction_provider', 
            'mekanism:ultimate_energy_cube', 'mekanism:ultimate_induction_cell', 'mekanism:ultimate_energy_cube'
        ],
        enable: true
    },
    {
        // Tome of Knowledge
        output: "projecte:tome",
        inputs: [
            'projectexpansion:final_star', 'projectexpansion:final_star', 'projectexpansion:final_star', 
            'projectexpansion:final_star', 'apotheosis:ender_library', 'projectexpansion:final_star', 
            'projectexpansion:final_star', 'projectexpansion:final_star', 'projectexpansion:final_star'
        ],
        enable: true
    },
    {
        // Transmutation Interface
        output: "projectexpansion:transmutation_interface",
        inputs: [
            'projectexpansion:basic_emc_link', 'projecte:condenser_mk1', 'projectexpansion:basic_emc_link', 
            'projecte:condenser_mk1', 'kubejs:architron', 'projecte:condenser_mk1', 
            'projectexpansion:basic_emc_link', 'projecte:condenser_mk1', 'projectexpansion:basic_emc_link'
        ],
        enable: true
    },
    {
        // Ender Chest
        output: "minecraft:ender_chest",
        inputs: [
            'minecraft:obsidian', 'minecraft:obsidian', 'minecraft:obsidian', 
            'minecraft:obsidian', 'minecraft:ender_eye', 'minecraft:obsidian', 
            'minecraft:obsidian', 'minecraft:obsidian', 'minecraft:obsidian'
        ],
        enable: true
    },
    {
        // Chest (from Logs)
        output: "4x minecraft:chest",
        inputs: [
            '#minecraft:logs', '#minecraft:logs', '#minecraft:logs', 
            '#minecraft:logs', 'minecraft:air', '#minecraft:logs',
            '#minecraft:logs', '#minecraft:logs', '#minecraft:logs'
        ],
        enable: true
    },
    {
        // Chest
        output: "minecraft:chest",
        inputs: [
            '#minecraft:planks', '#minecraft:planks', '#minecraft:planks', 
            '#minecraft:planks', 'minecraft:air', '#minecraft:planks', 
            '#minecraft:planks', '#minecraft:planks', '#minecraft:planks'
        ],
        enable: true
    },
    {
        // Bookshelf
        output: "minecraft:bookshelf",
        inputs: [
            '#minecraft:planks', '#minecraft:planks', '#minecraft:planks', 
            'minecraft:book', 'minecraft:book', 'minecraft:book',
            '#minecraft:planks', '#minecraft:planks', '#minecraft:planks'
        ],
        enable: true
    },
    {
        // Stick (from Logs)
        output: "16x minecraft:stick",
        inputs: [
            '#minecraft:logs', "", "",
            '#minecraft:logs'
        ],
        enable: true
    },
    {
        // Hopper
        output: "minecraft:hopper",
        inputs: [
            'minecraft:iron_ingot', '#minecraft:logs', 'minecraft:iron_ingot', 
            'minecraft:iron_ingot', '#minecraft:logs', 'minecraft:iron_ingot',
            'minecraft:air', 'minecraft:iron_ingot', 'minecraft:air'
        ],
        enable: true
    },
    {
        // Empty Dimension Tab 
        output: "rftoolsdim:empty_dimension_tab",
        inputs: [
            'minecraft:shulker_shell', 'rftoolspower:dimensionalcell_advanced', 'minecraft:shulker_shell', 
            'rftoolspower:dimensionalcell_advanced', 'minecraft:nether_star', 'rftoolspower:dimensionalcell_advanced', 
            'minecraft:shulker_shell', 'rftoolspower:dimensionalcell_advanced', 'minecraft:shulker_shell'
        ],
        enable: true
    },
    {
        // Quartz Enriched Iron
        output: "4x refinedstorage:quartz_enriched_iron",
        inputs: [
            'minecraft:iron_ingot', 'minecraft:iron_ingot', "",
		    'minecraft:iron_ingot', '#forge:dusts/quartz'
        ],
        enable: true
    },
    {
        // Dispenser
        output: "minecraft:dispenser",
        inputs: [
            '#minecraft:stone_crafting_materials', '#minecraft:stone_crafting_materials', '#minecraft:stone_crafting_materials', 
            '#minecraft:stone_crafting_materials', 'minecraft:bow', '#minecraft:stone_crafting_materials', 
            '#minecraft:stone_crafting_materials', 'minecraft:redstone', '#minecraft:stone_crafting_materials'
        ],
        enable: true
    },
    {
        // Gem Leggings
        output: "projecte:gem_leggings",
        inputs: [
            'projecte:rm_leggings', 'projecte:black_hole_band', 'minecraft:air', 
            'projecte:arcana_ring', 'projecte:klein_star_omega', 'minecraft:air', 
		    'minecraft:air', 'minecraft:air', 'minecraft:air'
        ],
        enable: true
    },
    {
        // Reinforced Deepslate
        output: "minecraft:reinforced_deepslate",
        inputs: [
            'deeperdarker:sculk_bone', 'deeperdarker:warden_carapace', 'deeperdarker:sculk_bone', 
            'deeperdarker:sculk_bone', 'minecraft:deepslate', 'deeperdarker:sculk_bone', 
            'deeperdarker:sculk_bone', 'deeperdarker:soul_crystal', 'deeperdarker:sculk_bone'
        ],
        enable: true
    },
    {
        // Blaze Block
        output: "kubejs:blaze_block",
        inputs: [
            'minecraft:blaze_rod', 'minecraft:blaze_rod', 'minecraft:blaze_rod',
            'minecraft:blaze_rod', 'minecraft:blaze_rod', 'minecraft:blaze_rod',
            'minecraft:blaze_rod', 'minecraft:blaze_rod', 'minecraft:blaze_rod'
        ],
        enable: true
    },
    {
        // Fallen Star
        output: "phantasm:fallen_star",
        inputs: [
            'thermal:blizz_powder', 'cyclic:cloud', 'thermal:blizz_powder',
            'cyclic:cloud', 'minecraft:nether_star', 'cyclic:cloud',
            'thermal:blizz_powder', 'cyclic:cloud', 'thermal:blizz_powder'
        ],
        enable: true
    },
    {
        // Stack Upgrade Omega Tier - Storage
        output: "sophisticatedstorage:stack_upgrade_omega_tier",
        inputs: [
            "projectexpansion:final_star_shard", "projectexpansion:magnum_star_omega", "projectexpansion:final_star_shard",
            "projectexpansion:fading_matter_block", "sophisticatedstorage:stack_upgrade_tier_5", "projectexpansion:fading_matter_block",
            "projectexpansion:final_star_shard", "projectexpansion:magnum_star_omega", "projectexpansion:final_star_shard"
        ],
        enable: true
    },
    {
        // Stack Upgrade Omega Tier - Backpack
        output: "sophisticatedbackpacks:stack_upgrade_omega_tier",
        inputs: [
            "projectexpansion:final_star_shard", "projectexpansion:magnum_star_omega", "projectexpansion:final_star_shard",
            "projectexpansion:fading_matter_block", "sophisticatedbackpacks:stack_upgrade_tier_4", "projectexpansion:fading_matter_block",
            "projectexpansion:final_star_shard", "projectexpansion:magnum_star_omega", "projectexpansion:final_star_shard"
        ],
        enable: true
    }
];

// Shapeless Recipes
// - Same as above
const shapelessRecipes = [
	{
        output: "refinedstorage:creative_controller",
        inputs: ["#refinedstorage:creative_controller", "#forge:dyes/light_blue"],
        enable: true
    },
    {
        output: "refinedstorage:light_gray_creative_controller",
        inputs: ["#refinedstorage:creative_controller", "#forge:dyes/light_gray"],
        enable: true
    },
    {
        output: "refinedstorage:lime_creative_controller",
        inputs: ["#refinedstorage:creative_controller", "#forge:dyes/lime"],
        enable: true
    },
    {
        output: "refinedstorage:magenta_creative_controller",
        inputs: ["#refinedstorage:creative_controller", "#forge:dyes/magenta"],
        enable: true
    },
    {
        output: "refinedstorage:orange_creative_controller",
        inputs: ["#refinedstorage:creative_controller", "#forge:dyes/orange"],
        enable: true
    },
    {
        output: "refinedstorage:pink_creative_controller",
        inputs: ["#refinedstorage:creative_controller", "#forge:dyes/pink"],
        enable: true
    },
    {
        output: "refinedstorage:purple_creative_controller",
        inputs: ["#refinedstorage:creative_controller", "#forge:dyes/purple"],
        enable: true
    },
    {
        output: "refinedstorage:red_creative_controller",
        inputs: ["#refinedstorage:creative_controller", "#forge:dyes/red"],
        enable: true
    },
    {
        output: "refinedstorage:white_creative_controller",
        inputs: ["#refinedstorage:creative_controller", "#forge:dyes/white"],
        enable: true
    },
    {
        output: "refinedstorage:yellow_creative_controller",
        inputs: ["#refinedstorage:creative_controller", "#forge:dyes/yellow"],
        enable: true
    },
    {
        output: "refinedstorage:gray_creative_controller",
        inputs: ["#refinedstorage:creative_controller", "#forge:dyes/gray"],
        enable: true
    },
    {
        output: "refinedstorage:cyan_creative_controller",
        inputs: ["#refinedstorage:creative_controller", "#forge:dyes/cyan"],
        enable: true
    },
    {
        output: "refinedstorage:blue_creative_controller",
        inputs: ["#refinedstorage:creative_controller", "#forge:dyes/blue"],
        enable: true
    },
    {
        output: "refinedstorage:brown_creative_controller",
        inputs: ["#refinedstorage:creative_controller", "#forge:dyes/brown"],
        enable: true
    },
    {
        output: "refinedstorage:green_creative_controller",
        inputs: ["#refinedstorage:creative_controller", "#forge:dyes/green"],
        enable: true
    },
    {
        output: "refinedstorage:black_creative_controller",
        inputs: ["#refinedstorage:creative_controller", "#forge:dyes/black"],
        enable: true
    },
	{
		// Firework Fix
		output: Item.of("minecraft:firework_rocket", 6, {Fireworks: {Flight: 1}}),
		inputs: ["minecraft:paper", "minecraft:paper", "minecraft:gunpowder", "minecraft:gunpowder"],
		enable: true
	},
	{
		// Firework Fix 2
		output: Item.of("minecraft:firework_rocket", 6, {Fireworks: {Flight: 2}}),
		inputs: ["minecraft:paper", "minecraft:paper", "minecraft:gunpowder", "minecraft:gunpowder", "minecraft:gunpowder", "minecraft:gunpowder"],
		enable: true
	},
	{
		// Firework Fix 3
		output: Item.of("minecraft:firework_rocket", 6, {Fireworks: {Flight: 3}}),
		inputs: ["minecraft:paper", "minecraft:paper", "minecraft:gunpowder", "minecraft:gunpowder", "minecraft:gunpowder", "minecraft:gunpowder", 
				 "minecraft:gunpowder", "minecraft:gunpowder"],
		enable: true
	},
    {
        // Fixes JAOPCA conversion to Thermal Extra
        output: "thermal_extra:zinc_dust",
        inputs: ["jaopca:dusts.zinc"],
        enable: true
    },
    {
        // Blaze Rod
        output: "9x minecraft:blaze_rod",
        inputs: ["kubejs:blaze_block"],
        enable: true
    },
    {
        // Nether Wart
        output: "4x minecraft:nether_wart",
        inputs: ["minecraft:nether_wart_block"],
        enable: true
    }
]

// Blasting Recipes
// - 'output' is required, the item id for the output
// - 'input' is required, the item id for the input
// - 'enable' is required, if true the recipe will register, if false it will not
const blastingRecipes = [
	{
		input: "draconicevolution:awakened_draconium_dust",
		output: "draconicevolution:awakened_draconium_ingot",
		enable: true
	},
	{
		input: "draconicevolution:draconium_dust",
		output: "draconicevolution:draconium_ingot",
		enable: true
	},
    {
        input: "jaopca:dusts.zinc",
        output: "create:zinc_ingot",
        enable: true
    }
]

// Stonecutting Recipes
// - 'outputs' is required, the item ids for the outputs
// - 'input' is required, the item id for the input
// - 'enable' is required, if true the recipe will register, if false it will not
// - 'exclude' is optional, items/tags in the list will be removed from the final added recipes
const stonecutRecipes = [
	{
		input: "#chisel_chipped_integration:factory_block",
		outputs: ["#chisel_chipped_integration:factory_block"],
		enable: true
	},
	{
		input: "#chisel_chipped_integration:laboratory_block",
		outputs: ["#chisel_chipped_integration:laboratory_block"],
		enable: true
	},
	{
		input: "#chisel_chipped_integration:technical_block",
		outputs: ["#chisel_chipped_integration:technical_block"],
		enable: true
	},
	{
		input: "#chisel_chipped_integration:tyrian",
		outputs: ["#chisel_chipped_integration:tyrian"],
		enable: true
	},
	{
		input: "#pa2_extras:storage_blocks/bronze",
		outputs: ["#pa2_extras:storage_blocks/bronze"],
		exclude: ["mekanism:block_bronze"],
		enable: true
	},
	{
		input: "#pa2_extras:storage_blocks/copper",
		outputs: ["#pa2_extras:storage_blocks/copper"],
		enable: true
	},
	{
		input: "#pa2_extras:storage_blocks/electrum",
		outputs: ["#pa2_extras:storage_blocks/electrum"],
		enable: true
	},
	{
		input: "#chipped:gold_block",
		outputs: ["#chipped:gold_block"],
		enable: true
	},
	{
		input: "#pa2_extras:storage_blocks/invar",
		outputs: ["#pa2_extras:storage_blocks/invar"],
		enable: true
	},
	{
		input: "#chipped:iron_block",
		outputs: ["#chipped:iron_block"],
		enable: true
	},
	{
		input: "#pa2_extras:storage_blocks/lead",
		outputs: ["#pa2_extras:storage_blocks/lead"],
		exclude: ["mekanism:block_lead"],
		enable: true
	},
	{
		input: "#pa2_extras:storage_blocks/nickel",
		outputs: ["#pa2_extras:storage_blocks/nickel"],
		enable: true
	},
	{
		input: "#forge:storage_blocks/silver",
		outputs: ["#forge:storage_blocks/silver"],
		enable: true
	},
	{
		input: "#forge:storage_blocks/steel",
		outputs: ["#forge:storage_blocks/steel"],
		exclude: ["mekanism:block_steel"],
		enable: true
	},
	{
		input: "#forge:storage_blocks/tin",
		outputs: ["#forge:storage_blocks/tin"],
		exclude: ["mekanism:block_tin"],
		enable: true
	},
	{
		input: "#forge:storage_blocks/uranium",
		outputs: ["#forge:storage_blocks/uranium"],
		exclude: ["mekanism:block_uranium"],
		enable: true
	},
	{
		input: "#chipped:black_wool",
		outputs: ["#chipped:black_wool"],
		enable: true
	},
	{
		input: "#chipped:blue_wool",
		outputs: ["#chipped:blue_wool"],
		enable: true
	},
	{
		input: "#chipped:brown_wool",
		outputs: ["#chipped:brown_wool"],
		enable: true
	},
	{
		input: "#chipped:cyan_wool",
		outputs: ["#chipped:cyan_wool"],
		enable: true
	},
	{
		input: "#chipped:gray_wool",
		outputs: ["#chipped:gray_wool"],
		enable: true
	},
	{
		input: "#chipped:green_wool",
		outputs: ["#chipped:green_wool"],
		enable: true
	},
	{
        input: "#chipped:light_blue_wool",
        outputs: ["#chipped:light_blue_wool"],
        enable: true
    },
    {
        input: "#chipped:light_gray_wool",
        outputs: ["#chipped:light_gray_wool"],
        enable: true
    },
    {
        input: "#chipped:lime_wool",
        outputs: ["#chipped:lime_wool"],
        enable: true
    },
    {
        input: "#chipped:magenta_wool",
        outputs: ["#chipped:magenta_wool"],
        enable: true
    },
    {
        input: "#chipped:orange_wool",
        outputs: ["#chipped:orange_wool"],
        enable: true
    },
    {
        input: "#chipped:pink_wool",
        outputs: ["#chipped:pink_wool"],
        enable: true
    },
    {
        input: "#chipped:purple_wool",
        outputs: ["#chipped:purple_wool"],
        enable: true
    },
    {
        input: "#chipped:red_wool",
        outputs: ["#chipped:red_wool"],
        enable: true
    },
    {
        input: "#chipped:white_wool",
        outputs: ["#chipped:white_wool"],
        enable: true
    },
    {
        input: "#chipped:yellow_wool",
        outputs: ["#chipped:yellow_wool"],
        enable: true
    },
	{
        input: "#chipped:black_carpet",
        outputs: ["#chipped:black_carpet"],
        enable: true
    },
    {
        input: "#chipped:blue_carpet",
        outputs: ["#chipped:blue_carpet"],
        enable: true
    },
    {
        input: "#chipped:brown_carpet",
        outputs: ["#chipped:brown_carpet"],
        enable: true
    },
    {
        input: "#chipped:cyan_carpet",
        outputs: ["#chipped:cyan_carpet"],
        enable: true
    },
    {
        input: "#chipped:gray_carpet",
        outputs: ["#chipped:gray_carpet"],
        enable: true
    },
    {
        input: "#chipped:green_carpet",
        outputs: ["#chipped:green_carpet"],
        enable: true
    },
    {
        input: "#chipped:light_blue_carpet",
        outputs: ["#chipped:light_blue_carpet"],
        enable: true
    },
    {
        input: "#chipped:light_gray_carpet",
        outputs: ["#chipped:light_gray_carpet"],
        enable: true
    },
    {
        input: "#chipped:lime_carpet",
        outputs: ["#chipped:lime_carpet"],
        enable: true
    },
    {
        input: "#chipped:magenta_carpet",
        outputs: ["#chipped:magenta_carpet"],
        enable: true
    },
    {
        input: "#chipped:orange_carpet",
        outputs: ["#chipped:orange_carpet"],
        enable: true
    },
    {
        input: "#chipped:pink_carpet",
        outputs: ["#chipped:pink_carpet"],
        enable: true
    },
    {
        input: "#chipped:purple_carpet",
        outputs: ["#chipped:purple_carpet"],
        enable: true
    },
    {
        input: "#chipped:red_carpet",
        outputs: ["#chipped:red_carpet"],
        enable: true
    },
    {
        input: "#chipped:white_carpet",
        outputs: ["#chipped:white_carpet"],
        enable: true
    },
    {
        input: "#chipped:yellow_carpet",
        outputs: ["#chipped:yellow_carpet"],
        enable: true
    }
]

// Advanced Recipes
// - This will use the 'custom' recipe builder from kubejs, check the documention of kubejs for more info on it.
// - Has the 'enable' field for the same reason as the rest
const advRecipes = [
	// Anti-Lag Alternatives 
	// - To the In-World transformation, but make it balanced so that In-World is still more favourable
	// - Uses Dissolution Chamber from Industrial Foregoing because it seemed to be the more logical one
	// - Only makes alternatives for the more used ones, Final Star Shard and similar will stay as is
	{
		// Redstone Crytal (outputs only 1)
		// - 1B of Water
		// - 2x Redstone Blocks
		// - 2x Fluix Dust
		// - 2x Sky Stone Dust
		// - 2x Charged Certus Quartz Crystal
		type: "industrialforegoing:dissolution_chamber",
		output: { item: "appflux:redstone_crystal", count: 1 },
		processingTime: 300,
		inputFluid: "{FluidName:\"minecraft:water\",Amount:1000}",
		input: [
			{ item: "minecraft:redstone_block" },
			{ item: "minecraft:redstone_block" },
			{ item: "ae2:fluix_dust" },
			{ item: "ae2:fluix_dust" },
			{ item: "ae2:sky_dust" },
			{ item: "ae2:sky_dust" },
			{ item: "ae2:charged_certus_quartz_crystal" },
			{ item: "ae2:charged_certus_quartz_crystal" }
		],
		enable: true
	},
	{
		// Sky Steel Ingot (outputs 2)
		// - 1B of Lava
		// - 3x Iron Ingot
		// - 3x Sky Stone Block
		// - 2x Charged Certus Quartz Crystal
		type: "industrialforegoing:dissolution_chamber",
		output: { item: "megacells:sky_steel_ingot", count: 1 },
		processingTime: 400,
		inputFluid: "{FluidName:\"minecraft:lava\",Amount:1000}",
		input: [
			{ item: "minecraft:iron_ingot" },
			{ item: "minecraft:iron_ingot" },
			{ item: "minecraft:iron_ingot" },
			{ item: "ae2:sky_stone_block" },
			{ item: "ae2:sky_stone_block" },
			{ item: "ae2:sky_stone_block" },
			{ item: "ae2:charged_certus_quartz_crystal" },
			{ item: "ae2:charged_certus_quartz_crystal" }
		],
		enable: true
	},
	{
		// Spent Nuclear Waste - Use 1 (as a sort of dupe for Plutonium Pellet)
		// - 2B of Spent Nuclear Waste
		// - 1.5B of Liquid Uranium Oxide
		// - 1x Plutonium Pellet
		// - 1000 Ticks
		//
		// Has an extra 500mb of "reactivated" nuclear waste
		type: "mekanism:reaction",
		duration: 1000,
		fluidInput: {
			amount: 1500,
			fluid: "mekanism:uranium_oxide"
		},
		gasInput: {
			amount: 2000,
			gas: "mekanism:spent_nuclear_waste"
		},
		itemInput: {
			ingredient: { item: "mekanism:pellet_plutonium" }
		},
		itemOutput: { item: "mekanism:pellet_plutonium", count: 2 },
		gasOutput: {
			amount: 500,
			gas: "mekanism:nuclear_waste"
		},
		enable: true
	},
	{
		// Spent Nuclear Waste - Use 2 (as a sort of dupe for Polonium Pellet)
		// - 2B of Spent Nuclear Waste
		// - 1.5B of Liquid Uranium Oxide
		// - 1x Polonium Pellet
		// - 1000 Ticks
		//
		// Has an extra 500mb of "reactivated" nuclear waste
		type: "mekanism:reaction",
		duration: 1000,
		fluidInput: {
			amount: 1500,
			fluid: "mekanism:uranium_oxide"
		},
		gasInput: {
			amount: 2000,
			gas: "mekanism:spent_nuclear_waste"
		},
		itemInput: {
			ingredient: { item: "mekanism:pellet_polonium" }
		},
		itemOutput: { item: "mekanism:pellet_polonium", count: 2 },
		gasOutput: {
			amount: 500,
			gas: "mekanism:nuclear_waste"
		},
		enable: true
	},
	{
		// Infused Archiveau
		// - 50/50 Eterna
		// - 67/68 Quanta
		// - 55/57 Arcana
		// - 1x Archiveau
		type: "apotheosis:keep_nbt_enchanting",
		conditions: [
			{
				type: "apotheosis:module",
				module: "enchantment"
			}
		],
		input: { item: "kubejs:archiveau" },
		requirements: {
			eterna: 50,
			quanta: 67,
			arcana: 55
		},
		max_requirements: {
			eterna: 50,
			quanta: 68,
			arcana: 57
		},
		result: { item: "pa2_extras:inf_archiveau", count: 1 },
		enable: true
	},
	{
		// Creative Controller for RS (mimics AE2 Creative Cell)
		// - 1x Final Star
		// - 5x Controller (default color)
		type: "powah:energizing",
		ingredients: [
			{ item: "projectexpansion:final_star" },
			{ item: "refinedstorage:controller" },
			{ item: "refinedstorage:controller" },
			{ item: "refinedstorage:controller" },
			{ item: "refinedstorage:controller" },
			{ item: "refinedstorage:controller" }
		],
		energy: 2147483646,
		result: { item: "refinedstorage:creative_controller" },
		enable: true
	},
	{
		// Royal Jelly to Source
		// - 1B = 4000 Source
		type: "starbunclemania:fluid_sourcelink",
		fluid: "the_bumblezone:royal_jelly_fluid_still",
		mb_to_source_ratio: 5.0,
		enable: true
	},
	{
		// Ether Gas to Source
		// - 1B = 2500 Source
		type: "starbunclemania:fluid_sourcelink",
		fluid: "industrialforegoing:ether_gas",
		mb_to_source_ratio: 2.5,
		enable: true
	},
	{
		// Pink Slime to Source
		// - 1B = 600 Source
		type: "starbunclemania:fluid_sourcelink",
		fluid: "industrialforegoing:pink_slime",
		mb_to_source_ratio: 0.6,
		enable: true
	},
	{
		// Add Archilution as an Pulverizer Catalyst
		// - Primary Mod: 5.0
		// - Secondary Mod: 10.0
		// - Energy Mod: 0.5
		// - Min Chance: 0.5
		// - Use Chance: 1.0
		type: "thermal:pulverizer_catalyst",
		ingredient: { item: "kubejs:archilution" },
		primary_mod: 5.0,
		secondary_mod: 10.0,
		energy_mod: 0.5,
		min_chance: 0.5,
		use_chance: 1.0,
		enable: true
	},
	{
		// Add Archilution as an Induction Smelter Catalyst
		// - Primary Mod: 7.0
		// - Secondary Mod: 7.0
		// - Energy Mod: 1.5
		// - Min Chance: 0.5
		// - Use Chance: 1.0
		type: "thermal:smelter_catalyst",
		ingredient: { item: "kubejs:archilution" },
		primary_mod: 7.0,
		secondary_mod: 7.0,
		energy_mod: 1.5,
		min_chance: 0.5,
		use_chance: 1.0,
		enable: true
	},
	{
		// Add Archimeat as an Insolator Catalyst
		// - Primary Mod: 5.0
		// - Secondary Mod: 5.0
		// - Energy Modifier: 0.9
		// - Min Chance: 0.5
		// - Use Chance: 1.0
		type: "thermal:insolator_catalyst",
		ingredient: { item: "kubejs:archimeat" },
		primary_mod: 5.0,
		secondary_mod: 5.0,
		energy_mod: 0.9,
		min_chance: 0.5,
		use_chance: 1.0,
		enable: true
	},
	{
		// Thermal Latex + Water = IF Latex
		// - 100mb of Thermal Latex (Dirty Latex)
		//
		// Result:
		// - 25mb of IF Latex
		// - 75mb of Tree Oil
		type: "thermal:refinery",
		ingredient: { fluid: "thermal:latex", amount: 100 },
		result: [
			{ fluid: "industrialforegoing:latex", amount: 25 },
			{ fluid: "thermal:tree_oil", amount: 75 }
		],
		energy: 8000,
		experience: 0,
		enable: true
	},
	{
		// Fixes the Adamantine Knife recipe (found it broken going through logs)
		type: "minecraft:smithing_transform",
		template: { item: "enlightened_end:adamantite_smithing_template" },
		base: { item: "farmersdelight:iron_knife" },
		addition: { item: "enlightened_end:adamantite_ingot" },
		result: { item: "enlightened_end:adamantite_knife", count: 1 },
		enable: true
	},
    {
        // Ruby as Alkahestry Charge
        type: "reliquary:alkahestry_charging",
        charge: 32,
        ingredient: { item: "thermal:ruby" },
		enable: true
    },
    {
        // Ruby Block as Alkahestry Charge
        type: "reliquary:alkahestry_charging",
        charge: 288,
        ingredient: { item: "thermal:ruby_block" },
		enable: true
    },
    {
        // 1x Compressed Ruby Block as Alkahestry Charge
        type: "reliquary:alkahestry_charging",
        charge: 576,
        ingredient: { item: "pa2_compressed:ruby_block_1x" },
		enable: true
    },
    {
        // 2x Compressed Ruby Block as Alkahestry Charge
        type: "reliquary:alkahestry_charging",
        charge: 1000,
        ingredient: { item: "pa2_compressed:ruby_block_2x" },
		enable: true
    },
    {
        // Sapphire as Alkahestry Charge
        type: "reliquary:alkahestry_charging",
        charge: 32,
        ingredient: { item: "thermal:sapphire" },
		enable: true
    },
    {
        // Sapphire Block as Alkahestry Charge
        type: "reliquary:alkahestry_charging",
        charge: 288,
        ingredient: { item: "thermal:sapphire_block" },
		enable: true
    },
    {
        // 1x Compressed Sapphire Block as Alkahestry Charge
        type: "reliquary:alkahestry_charging",
        charge: 576,
        ingredient: { item: "pa2_compressed:sapphire_block_1x" },
		enable: true
    },
    {
        // 2x Compressed Sapphire Block as Alkahestry Charge
        type: "reliquary:alkahestry_charging",
        charge: 1000,
        ingredient: { item: "pa2_compressed:sapphire_block_2x" },
		enable: true
    },
    {
        // Creative Reclamation Chamber
        type: "thermal:smelter",
        ingredients: [
            { item: "projectexpansion:final_star_shard", count: 8 },
            { item: "kubejs:archilution", count: 4 },
            { item: "thermalendergy:stellarium_block", count: 32 }
        ],
        result: [{ item: "thermal:machine_catalyst_creative_augment", count: 1 }],
        energy: 150000,
        enable: true
    },
    {
        // Architron
		type: "powah:energizing",
		ingredients: [
			{ item: "kubejs:archiveau" },
			{ item: "ironfurnaces:rainbow_core" },
			{ item: "powah:nitro_crystal_block" },
			{ item: "biggerreactors:ludicrite_block" },
			{ item: "rftoolspower:blazing_rod" },
			{ item: "appflux:flux_accessor" }
		],
		energy: 2147483646,
		result: { item: "kubejs:architron" },
		enable: true
    },
    {
        // Creative Energy Cell (Applied Energistics)
		type: "powah:energizing",
		ingredients: [
			{ item: "projectexpansion:final_star" },
			{ item: "ae2:dense_energy_cell" },
			{ item: "ae2:dense_energy_cell" },
			{ item: "ae2:dense_energy_cell" },
			{ item: "ae2:dense_energy_cell" },
			{ item: "ae2:dense_energy_cell" }
		],
		energy: 2147483646,
		result: { item: "ae2:creative_energy_cell" },
		enable: true
    },
    {
        // Creative Energy Cube (Mekanism)
		type: "powah:energizing",
		ingredients: [
			{ item: "projectexpansion:final_star" },
			{ item: "mekanism:creative_energy_cube" },
			{ item: "mekanism:creative_energy_cube" },
			{ item: "mekanism:creative_energy_cube" },
			{ item: "mekanism:creative_energy_cube" },
			{ item: "mekanism:creative_energy_cube" }
		],
		energy: 2147483646,
		result: { item: "mekanism:creative_energy_cube", nbt: {mekData:{EnergyContainers:[{Container:0,stored:"18446744073709551615.9999"}],componentConfig:{config0:{side0:4,side1:4,side2:4,side3:4,side4:4,side5:4}}}} },
		enable: true
    },
    {
        // Creative Energy Cube (Mekanism)
		type: "powah:energizing",
		ingredients: [
			{ item: "kubejs:blaze_block" }
		],
		energy: 810000,
		result: { item: "powah:blazing_crystal_block" },
		enable: true
    },
    {
        // Zinc Ingot (Legacy)
        type: "thermal:smelter",
        ingredients: [
            { item: "jaopca:dusts.zinc", count: 1 }
        ],
        result: [{ item: "create:zinc_ingot", count: 1 }],
        energy: 4000,
        enable: true
    },
	{
		// Add Architron as a Nitratic Igniter Catalyst
		// - Primary Mod: 7.0
		// - Secondary Mod: 7.0
		// - Energy Mod: 3.0
		type: "thermal_extra:nitratic_igniter_catalyst",
		ingredient: { item: "kubejs:architron" },
		primary_mod: 7.0,
		secondary_mod: 7.0,
		energy_mod: 3.0,
		enable: true
	},
    {
        // Empty a Molten Abyssal Bucket (Create)
		type: "create:emptying",
		ingredients: [{ item: "thermal_extra:abyssal_bucket" }],
        results: [
            { item: "minecraft:bucket" },
            { fluid: "thermal_extra:abyssal", amount: 1000 }
        ],
		enable: true
    },
    {
        // Obsidian to Liquid Obsidian
        type: "thermal:crucible",
        ingredient: { item: "cyclic:gem_obsidian" },
        result: [{ fluid: "biggerreactors:liquid_obsidian" , amount: 1000 }],
        energy: 160000,
        enable: true
    },
    {
        // Molten Soul Infused
        type: "create:mixing",
        heatRequirement: "heated",
        ingredients: [
            { fluid: "thermal_extra:raw_iron", amount: 90 },
            { item: "thermal_extra:soul_sand_dust" },
            { item: "thermal_extra:soul_sand_dust" },
            { fluid: "thermal_extra:raw_copper", amount: 90 }
        ],
        results: [{ fluid: "thermal_extra:soul_infused", amount: 180 }],
        enable: true
    },
    {
        // Molten Shellite
        type: "create:mixing",
        heatRequirement: "heated",
        ingredients: [
            { fluid: "thermal_extra:raw_lead", amount: 90 },
            { item: "minecraft:shulker_shell" },
            { fluid: "thermal_extra:raw_nickel", amount: 90 }
        ],
        results: [{ fluid: "thermal_extra:shellite", amount: 180 }],
        enable: true
    },
    {
        // Molten Twinite
        type: "create:mixing",
        heatRequirement: "heated",
        ingredients: [
            { item: "minecraft:blaze_rod" },
            { fluid: "thermal_extra:raw_tin", amount: 180 },
            { item: "minecraft:obsidian" }
        ],
        results: [{ fluid: "thermal_extra:twinite", amount: 180 }],
        enable: true
    },
    {
        // Molten Dragonsteel
        type: "create:mixing",
        heatRequirement: "heated",
        ingredients: [
            { item: "minecraft:netherite_scrap" },
            { item: "thermal_extra:ancient_dust" },
            { fluid: "thermal_extra:raw_nickel", amount: 90 }
        ],
        results: [{ fluid: "thermal_extra:dragonsteel", amount: 180 }],
        enable: true
    },
    {
        // Molten Abyssal
        type: "create:mixing",
        heatRequirement: "superheated",
        ingredients: [
            { item: "minecraft:netherite_scrap" },
            { tag: "forge:dusts/diamond" },
            { tag: "forge:dusts/diamond" },
            { item: "minecraft:echo_shard" }
        ],
        results: [{ fluid: "thermal_extra:abyssal", amount: 180 }],
        enable: true
    },
    {
        // Blazing Rod - Reaction Chamber
        type: "advanced_ae:reaction",
        energy: 2500000,
        fluid: { 
            fluidStack: { FluidName: "enlightened_end:ooze_fluid", Amount: 5000 }
        },
        input_items: [
            { 
                amount: 1,
                ingredient: { item: "minecraft:blaze_rod" }
            }
        ],
        output: { "#": 1, "#c": "ae2:i", id: "rftoolspower:blazing_rod" },
        enable: true
    },
	{
		type: "thermal:press",
		ingredients: [
			{ item: "minecraft:quartz", count: 4 },
			{ item: "thermal:press_gear_die" }
		],
		result: [ { item: "thermal:quartz_gear" } ],
		conditions: [ { flag: "quartz", type: "thermal:flag" } ],
		enable: true
	},
	{
		type: "thermal:press",
		ingredients: [
			{ item: "minecraft:lapis_lazuli", count: 4 },
			{ item: "thermal:press_gear_die" }
		],
		result: [ { item: "thermal:lapis_gear" } ],
		conditions: [ { flag: "lapis", type: "thermal:flag" } ],
		enable: true
	},
	{
		type: "thermal:press",
		ingredients: [
			{ item: "minecraft:emerald", count: 4 },
			{ item: "thermal:press_gear_die" }
		],
		result: [ { item: "thermal:emerald_gear" } ],
		conditions: [ { flag: "emerald", type: "thermal:flag" } ],
		enable: true
	}
]

// Auto Population of Energizing Recipes
// - This allows you to make a recipe that extrapolates into compressed versions too
// - Has the 'enable' field for the same reason as the rest
const energizingAutoPopulate = [
    {
		ingredients: {
			0: ["minecraft:diamond", 
                "minecraft:diamond_block", 
                "allthecompressed:diamond_block_1x",
                "allthecompressed:diamond_block_2x",
                "allthecompressed:diamond_block_3x",
                "allthecompressed:diamond_block_4x",
                "allthecompressed:diamond_block_5x",
                "allthecompressed:diamond_block_6x",
                "allthecompressed:diamond_block_7x",
                "allthecompressed:diamond_block_8x",
                "allthecompressed:diamond_block_9x"
            ]
        },
		energy: 300000,
		results: [
            "powah:crystal_niotic", 
            "powah:niotic_crystal_block",
            "allthecompressed:niotic_crystal_block_1x",
            "allthecompressed:niotic_crystal_block_2x",
            "allthecompressed:niotic_crystal_block_3x",
            "allthecompressed:niotic_crystal_block_4x",
            "allthecompressed:niotic_crystal_block_5x",
            "allthecompressed:niotic_crystal_block_6x",
            "allthecompressed:niotic_crystal_block_7x",
            "allthecompressed:niotic_crystal_block_8x",
            "allthecompressed:niotic_crystal_block_9x"
        ],
		enable: false
    },
    /*{
		ingredients: {
			0: ["minecraft:emerald", "minecraft:emerald_block"]
        },
		energy: 1000000,
		results: ["powah:crystal_spirited", "powah:spirited_crystal_block"],
		enable: true
    },
    {
		ingredients: {
			0: ["mekanism:ingot_uranium", "mekanism:block_uranium"]
        },
		energy: 300000,
		results: ["powah:uraninite", "powah:uraninite_block"],
		enable: true
    }*/
]

// Replaces inputs on recipes
// - Key is the item to be replaced, value the item to replace with
const inputReplacer =  {
	"cyclic:compressed_cobblestone": "allthecompressed:cobblestone_1x",
    "cyclic:crafting_stick": "crafting_on_a_stick:crafting_table"
}

// Replaces inputs on recipes by id
// - Key is the recipe id to be replaced in
// - The value contains 'origin' for the item to get replaced and 'replace' for the replacer
const idReplacer =  {
	"advanced_ae:quantum_chest": { origin: "minecraft:netherite_chestplate", replace: "projecte:rm_chestplate"},
    "advanced_ae:quantum_helmet": { origin: "minecraft:netherite_helmet", replace: "projecte:rm_helmet"},
    "advanced_ae:quantum_leggings": { origin: "minecraft:netherite_leggings", replace: "projecte:rm_leggings"},
    "advanced_ae:quantum_boots": { origin: "minecraft:netherite_boots", replace: "projecte:rm_boots"}
}

// Replaces all items of a specific type in all scripts that have it, regardless of where the item is
// - Key is item to replace, value is the item to replace with
const massReplacer = {
    "thermal:ender_pearl_dust": "ae2:ender_dust",
    "thermal:sawdust": "mekanism:sawdust",
    "createdeco:iron_coin": "thermal:iron_coin",
    "createdeco:gold_coin": "thermal:gold_coin",
    "createdeco:copper_coin": "thermal:copper_coin",
    "createdeco:netherite_coin": "thermal:netherite_coin",
    "createaddition:copper_rod": "thermal_extra:copper_rod",
    "createaddition:iron_rod": "thermal_extra:iron_rod",
    "createaddition:gold_rod": "thermal_extra:gold_rod",
    "createaddition:electrum_rod": "thermal_extra:electrum_rod",
    "create:honey": "the_bumblezone:honey_fluid_still",
    "cofh_core:honey": "the_bumblezone:honey_fluid_still",
    "cyclic:honey": "the_bumblezone:honey_fluid_still",
    "cyclic:honey_bucket": "the_bumblezone:honey_bucket",
    "create:honey_bucket": "the_bumblezone:honey_bucket"
}

// Adds a recipe to turn a block with saved NBT into the original recipe one (for stacking)
// - Items will generate a shapeless recipe that takes the block and returns a no NBT one
const nbtVoider = [
	/draconicevolution:.+_injector/,
    /easy_villagers:(auto_)?trader/,
    /ironfurnaces:.+_furnace/
]

// Adds recipes that use the philosopher's stone
// - Works similar to Shapeless
// - Takes multiple input streams for sequence recipes
// - Also counts the reverse recipe
const philoStone = "projecte:philosophers_stone";
const philoCrafting = [
    {
        // Alchemical Fuel Blocks
        pattern: [
            philoStone, "%entry", "%entry",
            "%entry", "%entry"
        ],
        entries: [
            "thermal:charcoal_block", "minecraft:coal_block", "projecte:alchemical_coal_block", "projecte:mobius_fuel_block",
            "projecte:aeternalis_fuel_block", "projectexpansion:magenta_fuel_block", "projectexpansion:pink_fuel_block", "projectexpansion:purple_fuel_block",
            "projectexpansion:violet_fuel_block", "projectexpansion:blue_fuel_block", "projectexpansion:cyan_fuel_block", "projectexpansion:green_fuel_block",
            "projectexpansion:lime_fuel_block", "projectexpansion:yellow_fuel_block", "projectexpansion:orange_fuel_block", "projectexpansion:white_fuel_block"
        ],
        enable: true
    },
    {
        // Iron to Gold Block
        pattern: [
            philoStone, "%entry", "%entry",
            "%entry", "%entry", "%entry",
            "%entry", "%entry", "%entry"
        ],
        entries: [
            "minecraft:iron_block", "minecraft:gold_block"
        ],
        enable: true
    },
    {
        // Gold to Diamond Block
        pattern: [
            philoStone, "%entry", "%entry",
            "%entry", "%entry"
        ],
        entries: [
            "minecraft:gold_block", "minecraft:diamond_block"
        ],
        enable: true
    },
    {
        // Iron to Ender Pearl Block
        pattern: [
            philoStone, "%entry", "%entry",
            "%entry", "%entry"
        ],
        entries: [
            "minecraft:iron_block", "cyclic:eye_teleport"
        ],
        enable: true
    }
]

//---[CODE]---------------------------------------------------------------------------------------------------------------------------------------

// Energy Formula for Energizing Auto Populate
const energizingEnergyCalc = (step, min) => min * Math.pow((2147483646 / min), (step / 10));

// Simple recipe registration
ServerEvents.recipes(event => {
	// Applies Shapeless recipes
	shapelessRecipes.forEach(recipe => {
		if (recipe.enable)
		{
            if (recipe.outputs !== undefined)
            {
                recipe.outputs.forEach(entry => {
                    let ingredients = [];

                    recipe.inputs.forEach(input => {
                        if (typeof input === "string" && input.startsWith("%"))
                            ingredients.push(entry.overrides[input.substring(1)]);
                        else
                            ingredients.push(input);
                    });

                    event.shapeless(entry.output, ingredients);
                });
            }
            else
			    event.shapeless(recipe.output, recipe.inputs);
		}
	});

    global.teFixer.forEach(entry => {
        Object.keys(entry.recipes).forEach(old => {
            event.shapeless(entry.recipes[old], ["thermal_extra:" + old]);
        })
    });

    // Applies Philosopher Stone crafting
    philoCrafting.forEach(recipe => {
        if (recipe.enable)
        {
            for (let i = 1; i < recipe.entries.length; i++)
            {
                let prev = recipe.entries[i-1];
                let curr = recipe.entries[i];
                let patCount = recipe.pattern.reduce((count, val) => val === "%entry" ? count + 1 : count, 0);

                event.shapeless(curr, recipe.pattern.map(val => val === "%entry" ? prev : val));
                event.shapeless(`${patCount}x ${prev}`, [philoStone, curr]);
            }
        }
    })
	
	// Applies Shaped Recipes
	shapedRecipes.forEach(recipe => {
		if (recipe.enable)
		{
            if (recipe.outputs !== undefined)
            {
                recipe.outputs.forEach(entry => {
                    event.shaped(entry.output, ["012", "345", "678"], {
                        "0": typeof recipe.inputs[0] === "string" && recipe.inputs[0].startsWith("%") ? entry.overrides[recipe.inputs[0].substring(1)] : recipe.inputs[0],
                        "1": typeof recipe.inputs[1] === "string" && recipe.inputs[1].startsWith("%") ? entry.overrides[recipe.inputs[1].substring(1)] : recipe.inputs[1],
                        "2": typeof recipe.inputs[2] === "string" && recipe.inputs[2].startsWith("%") ? entry.overrides[recipe.inputs[2].substring(1)] : recipe.inputs[2],
                        "3": typeof recipe.inputs[3] === "string" && recipe.inputs[3].startsWith("%") ? entry.overrides[recipe.inputs[3].substring(1)] : recipe.inputs[3],
                        "4": typeof recipe.inputs[4] === "string" && recipe.inputs[4].startsWith("%") ? entry.overrides[recipe.inputs[4].substring(1)] : recipe.inputs[4],
                        "5": typeof recipe.inputs[5] === "string" && recipe.inputs[5].startsWith("%") ? entry.overrides[recipe.inputs[5].substring(1)] : recipe.inputs[5],
                        "6": typeof recipe.inputs[6] === "string" && recipe.inputs[6].startsWith("%") ? entry.overrides[recipe.inputs[6].substring(1)] : recipe.inputs[6],
                        "7": typeof recipe.inputs[7] === "string" && recipe.inputs[7].startsWith("%") ? entry.overrides[recipe.inputs[7].substring(1)] : recipe.inputs[7],
                        "8": typeof recipe.inputs[8] === "string" && recipe.inputs[8].startsWith("%") ? entry.overrides[recipe.inputs[8].substring(1)] : recipe.inputs[8]
                    });
                });
            }
            else
            {
                event.shaped(recipe.output, ["012", "345", "678"], {
                    "0": recipe.inputs[0],
                    "1": recipe.inputs[1],
                    "2": recipe.inputs[2],
                    "3": recipe.inputs[3],
                    "4": recipe.inputs[4],
                    "5": recipe.inputs[5],
                    "6": recipe.inputs[6],
                    "7": recipe.inputs[7],
                    "8": recipe.inputs[8]
                });
            }
		}
	});
	
	// Applies blasting recipes
	blastingRecipes.forEach(recipe => {
		if (recipe.enable)
		{
			event.blasting(recipe.output, recipe.input);
		}
	});
	
	// Applies stonecutting recipes
	stonecutRecipes.forEach(recipe => {
		if (recipe.enable)
		{
			recipe.outputs.forEach(out => {
				Ingredient.of(out).getItemIds().forEach(id => {
					if (recipe.exclude && recipe.exclude.includes(id))
						return;
					
					event.stonecutting(id, recipe.input);
				});
			});
		}
	});
	
	// Applies Custom Recipes
	advRecipes.forEach(recipe => {
		if (recipe.enable)
			event.custom(recipe);
	});

    energizingAutoPopulate.forEach(recipe => {
        if (!recipe.enable)
            return;

        let step = 0;
        recipe.results.forEach(result => {
            let energy = energizingEnergyCalc(step, recipe.energy);

            event.custom({
                type: "powah:energizing",
                ingredients: [
                    { item: recipe.ingredients[0] !== undefined ? recipe.ingredients[0][step] : "minecraft:air" },
                    { item: recipe.ingredients[1] !== undefined ? recipe.ingredients[1][step] : "minecraft:air" },
                    { item: recipe.ingredients[2] !== undefined ? recipe.ingredients[2][step] : "minecraft:air" },
                    { item: recipe.ingredients[3] !== undefined ? recipe.ingredients[3][step] : "minecraft:air" },
                    { item: recipe.ingredients[4] !== undefined ? recipe.ingredients[4][step] : "minecraft:air" },
                    { item: recipe.ingredients[5] !== undefined ? recipe.ingredients[5][step] : "minecraft:air" },
                ],
                energy: energy,
                result: { item: result }
            });

            step++;
        });
    });
	
	// Applies replacements
	Object.keys(inputReplacer).forEach(origin => {
		event.replaceInput({ input: origin }, origin, inputReplacer[origin]);
	});

    Object.keys(idReplacer).forEach(id => {
        const info = idReplacer[id];
		event.replaceInput({ id: id }, info.origin, info.replace);
	});

    // Applies mass replacement
    event.forEachRecipe({}, recipe => {
        let baseJson = "" + recipe.json.toString();
        let changed = false;

        Object.keys(massReplacer).forEach(origin => {
            const regex = new RegExp("\\b" + origin + "\\b", "g");

            if (baseJson.search(regex) === -1)
                return;
    
            baseJson = baseJson.replace(regex, massReplacer[origin]);
            changed = true;
        });

        if (!changed)
            return;
        
        recipe.json = baseJson;
        recipe.save();
    });

	// Applies NBT voider
	nbtVoider.forEach(item => {
        Ingredient.of(item).getItemIds().forEach(id => {
            event.shapeless(Item.of(id, 1), id);
        });
	});
	
	// Generate Recipes for the Compressed blocks
	global.compressedBlocks.forEach(entry => {
		let baseId = entry.base.replace(/.+:(.+)/, "pa2_compressed:$1");
		
		for (let i = 1; i <= 9; i++)
		{
			event.shaped(baseId + `_${i}x`, ["###", "###", "###"], {
				"#": i === 1 ? entry.base : baseId + `_${i-1}x`
			});
			
			event.shapeless(Item.of(i === 1 ? entry.base : baseId + `_${i-1}x`, 9), [baseId + `_${i}x`]);
		}
	});
});